
-- Rain parameters
kPPS = 40;               -- Number of particles generated per second
kGravity =50 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("flame2");
  SetBlendMode( kBlendNormal);
  SetNumParticles(1000);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(4500);
TestDone = NewTimeout(6000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(8,12), Vec3(15, 36) );
   InitVelocity( "vRange", Vec3(-156,15), Vec3(-90,10) );
   InitScale( "fRange", 0.5, 1 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

Gravity(-.15* kGravity);

   Do("move");
   DoAge("iAge");
   
   DoScale("fScale",
      .15, 1500,
      2, 1500);
   Do("expire", 800)

--DoUp( "vRotate", -.5, .5 );


end

